/*
 * Decompiled with CFR 0.152.
 */
package ags.communication;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataUtil {
    public static long CPU_SPEED = 1020500L;
    public static long NANOS_PER_SECOND = 1000000000L;
    public static long NANOS_PER_CHAR = DataUtil.nanosPerCharAtSpeed(115200L);

    static long nanosPerCharAtSpeed(long speed) {
        long result = NANOS_PER_SECOND * 9L / speed;
        return result;
    }

    static long cyclesToNanos(long cycles) {
        return NANOS_PER_SECOND * cycles / CPU_SPEED;
    }

    static void nanosleep(long duration) {
        if (duration > 0L) {
            LockSupport.parkNanos(duration);
        }
    }

    private DataUtil() {
    }

    public static String convertFromAppleText(String in) {
        if (in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (char c : in.toCharArray()) {
            out.append((char)(c & 0x7F));
        }
        return out.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (byte b : data) {
            out.append((char)b);
        }
        return out.toString();
    }

    public static String asAppleScreenHex(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c < ' ') continue;
            out.append(Integer.toHexString(c | 0x80)).append(' ');
        }
        return out.toString();
    }

    public static byte[] getWord(int i) {
        byte[] word = new byte[]{(byte)(i % 256), (byte)(i / 256)};
        return word;
    }

    public static String getFileAsString(String file) {
        InputStream stream = DataUtil.class.getResourceAsStream(file);
        StringBuffer data = new StringBuffer();
        byte[] buf = new byte[256];
        int read = 0;
        try {
            while ((read = stream.read(buf)) > 0) {
                String s = new String(buf, 0, read);
                data.append(s);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return data.toString();
    }

    public static byte[] getFileAsBytes(String file) throws IOException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        int size = 0;
        try {
            size = stream.available();
        }
        catch (Throwable ex) {
            System.out.println("Error reading file " + file);
            Logger.getLogger(DataUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException("Error reading " + file);
        }
        ByteBuffer bb = ByteBuffer.allocate(size);
        byte[] buf = new byte[256];
        int read = 0;
        try {
            while ((read = stream.read(buf)) > 0) {
                bb.put(buf, 0, read);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DataUtil.class.getName()).log(Level.WARNING, null, ex);
        }
        System.out.println("Read file " + file);
        return bb.array();
    }

    public static boolean bufferContains(ByteBuffer bb, byte[] data) {
        int d = 0;
        boolean match = false;
        for (int i = 0; i < bb.position() && d < data.length; ++i) {
            if (bb.get(i) == data[d]) {
                match = true;
                ++d;
                continue;
            }
            match = false;
            d = 0;
        }
        return match;
    }

    public static void wait(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static byte[] packbits(int target, byte[] input) {
        ArrayList<Byte> out = new ArrayList<Byte>();
        out.add((byte)(0xFF & target));
        out.add((byte)((0xFF00 & target) >> 8));
        int pos = 0;
        while (pos < input.length) {
            boolean rawData = true;
            if (pos < input.length - 4 && input[pos] == input[pos + 2] && input[pos + 1] == input[pos + 3]) {
                rawData = false;
                int numberReps = 0;
                int seek = pos + 4;
                boolean foundPattern = true;
                while (seek < input.length - 2 && foundPattern && numberReps < 127) {
                    if (input[pos] == input[seek] && input[pos + 1] == input[seek + 1]) {
                        ++numberReps;
                        seek += 2;
                        continue;
                    }
                    foundPattern = false;
                }
                byte size = (byte)(0xFF & 128 + numberReps);
                out.add(size);
                out.add(input[pos]);
                out.add(input[pos + 1]);
                pos = seek;
            }
            if (!rawData) continue;
            int seek = pos;
            boolean foundPattern = false;
            int count = 0;
            while (seek < input.length && !foundPattern && count < 127) {
                if (seek < input.length - 4 && input[seek] == input[seek + 2] && input[seek + 1] == input[seek + 3]) {
                    foundPattern = true;
                    continue;
                }
                ++seek;
                ++count;
            }
            out.add((byte)(0xFF & count));
            for (int i = 0; i < count; ++i) {
                out.add(input[pos + i]);
            }
            pos = seek;
        }
        out.add((byte)0);
        byte[] result = new byte[out.size()];
        for (int i = 0; i < out.size(); ++i) {
            result[i] = (Byte)out.get(i);
        }
        return result;
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return null;
        }
        byte[] out = new byte[b1.length];
        for (int i = 0; i < b1.length; ++i) {
            out[i] = (byte)(0xFF & (b1[i] ^ b2[i]));
        }
        return out;
    }

    public static byte[] truncateBeginningZeros(byte[] in) {
        int lastRealData;
        for (lastRealData = 0; lastRealData < in.length && in[lastRealData] == 0; ++lastRealData) {
        }
        if (lastRealData == 0) {
            return in;
        }
        byte[] result = new byte[in.length - lastRealData];
        for (int i = lastRealData; i < in.length; ++i) {
            result[i - lastRealData] = in[i];
        }
        return result;
    }

    public static byte[] truncateEndingZeros(byte[] in) {
        int lastRealData;
        for (lastRealData = in.length - 1; lastRealData >= 0 && in[lastRealData] == 0; --lastRealData) {
        }
        if (lastRealData == in.length - 1) {
            return in;
        }
        byte[] result = new byte[lastRealData + 1];
        for (int i = 0; i < lastRealData + 1; ++i) {
            result[i] = in[i];
        }
        return result;
    }

    public static byte[] packScreenUpdate(int address, byte[] oldScreen, byte[] newScreen) {
        byte[] diff = DataUtil.xor(oldScreen, newScreen);
        byte[] smaller = DataUtil.truncateEndingZeros(diff);
        byte[] evenSmaller = DataUtil.truncateBeginningZeros(smaller);
        return DataUtil.packbits(address += smaller.length - evenSmaller.length, evenSmaller);
    }
}

